/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.features;

import blueduck.outerend.blocks.CrystalBudBlock;
import blueduck.outerend.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import shadow.com.terraformersmc.terraform.shapes.api.Position;
import shadow.com.terraformersmc.terraform.shapes.api.Quaternion;
import shadow.com.terraformersmc.terraform.shapes.api.Shape;
import shadow.com.terraformersmc.terraform.shapes.impl.Shapes;
import shadow.com.terraformersmc.terraform.shapes.impl.filler.SimpleFiller;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.pathfinder.AddLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.BendLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.DilateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.RotateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import shadow.com.terraformersmc.terraform.shapes.impl.validator.SafelistValidator;

public class CragMoonFeature
extends Feature<NoFeatureConfig> {
    public CragMoonFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        double length;
        double height;
        double width;
        double Zrot;
        double Yrot;
        double Xrot;
        double ballMovementZ;
        BlockState VIOLITE = ((Block)BlockRegistry.VIOLITE.get()).func_176223_P();
        List<BlockState> WHITELIST = Arrays.asList(VIOLITE, Blocks.field_150350_a.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        if (reader.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos = reader.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos).func_177981_b(random.nextInt(20) + 40)).func_177956_o() == 0) {
            pos = pos.func_177981_b(random.nextInt(30) + 45);
        }
        double scale = MathHelper.func_219803_d((double)random.nextDouble(), (double)0.2, (double)0.3);
        if (random.nextDouble() < 0.4) {
            scale *= 1.6;
            if (random.nextDouble() < 0.2) {
                scale *= 2.0;
            }
        }
        double yScale = MathHelper.func_219803_d((double)random.nextDouble(), (double)0.6, (double)1.2);
        double uniformXrot = random.nextDouble() * 360.0;
        double uniformYrot = random.nextDouble() * 360.0;
        double uniformZrot = random.nextDouble() * 360.0;
        double radius = 15.0;
        double innerRadius = radius - radius / 5.0;
        Shape shape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
        shape.applyLayer(new AddLayer(Shapes.ellipsoid(radius, radius, radius))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true))).applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, VIOLITE)));
        int extraBumps = random.nextInt(16) + 36;
        Shape bumpShape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
        for (int i = 0; i < extraBumps; ++i) {
            double Xrot2 = random.nextDouble() * 360.0;
            double Yrot2 = random.nextDouble() * 360.0;
            double Zrot2 = random.nextDouble() * 360.0;
            double movementX = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            double movementY = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            double movementZ = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            double width2 = radius / 5.0 + random.nextDouble() * innerRadius / 5.0;
            double height2 = radius / 5.0 + random.nextDouble() * innerRadius / 5.0;
            double length2 = radius - innerRadius + radius;
            bumpShape.applyLayer(new AddLayer(Shapes.ellipsoid(width2, height2, length2).applyLayer(new RotateLayer(Quaternion.of(Xrot2, Yrot2, Zrot2, true))))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new TranslateLayer(Position.of(movementX, movementY, movementZ))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true)));
        }
        bumpShape.applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, VIOLITE)));
        Shape innerShape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
        innerShape.applyLayer(new AddLayer(Shapes.ellipsoid(innerRadius, innerRadius, innerRadius))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true))).applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, Blocks.field_150350_a.func_176223_P())));
        int extraInsideBumps = random.nextInt(16) + 32;
        Shape ballShape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
        for (int i = 0; i < extraInsideBumps; ++i) {
            double ballMovementX = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            double ballMovementY = innerRadius - innerRadius / 5.0;
            ballMovementZ = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            Xrot = random.nextDouble() * 360.0;
            Yrot = random.nextDouble() * 360.0;
            Zrot = random.nextDouble() * 360.0;
            width = radius / 5.0 + random.nextDouble() * innerRadius / 7.0;
            height = radius / 5.0 + random.nextDouble() * innerRadius / 7.0;
            length = radius / 9.0 + random.nextDouble() * innerRadius / 12.0;
            ballShape.applyLayer(new AddLayer(Shapes.ellipsoid(width, height, length))).applyLayer(new TranslateLayer(Position.of(ballMovementX, ballMovementY, ballMovementZ))).applyLayer(new RotateLayer(Quaternion.of(Xrot, Yrot, Zrot, true))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true)));
        }
        ballShape.applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, VIOLITE)));
        int holesInside = random.nextInt(6);
        Shape holeShape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
        for (int i = 0; i < holesInside; ++i) {
            double ballMovementX = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            ballMovementZ = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            Xrot = random.nextDouble() * 360.0;
            Yrot = random.nextDouble() * 360.0;
            Zrot = random.nextDouble() * 360.0;
            width = radius / 9.0 + random.nextDouble() * innerRadius / 19.0;
            height = radius / 9.0 + random.nextDouble() * innerRadius / 19.0;
            length = (radius - innerRadius) * (radius / 5.0) + radius;
            holeShape.applyLayer(new AddLayer(Shapes.ellipsoid(width, height, length))).applyLayer(new TranslateLayer(Position.of(ballMovementX, 0.0, ballMovementZ))).applyLayer(new RotateLayer(Quaternion.of(Xrot, Yrot, Zrot, true))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true)));
        }
        holeShape.applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, Blocks.field_150350_a.func_176223_P())));
        int outsideCrystals = random.nextInt(16) + 4;
        for (int i = 0; i < outsideCrystals; ++i) {
            BlockState CRYSTAL_TYPE = ((Block)BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:crystal_blocks")).func_205596_a(random)).func_176223_P();
            double shardLength = random.nextDouble() * (radius / 2.0) + radius / 5.0;
            double shardRadius = random.nextDouble() * 0.3 + 2.0;
            double shardArc = random.nextDouble() * 30.0;
            double Xrot3 = random.nextDouble() * 25.0;
            double Zrot3 = random.nextDouble() * 10.0;
            double Yrot3 = random.nextDouble() * 360.0 * (double)(i + 1);
            double totalXrot = random.nextDouble() * 360.0;
            double totalYrot = random.nextDouble() * 360.0;
            double totalZrot = random.nextDouble() * 360.0;
            double shardMovementX = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            double shardMovementY = radius;
            double shardMovementZ = random.nextDouble() * (radius / 3.0) - radius / 6.0;
            Shape crystalShape = Shape.of(point -> false, Position.of(0.0, 0.0, 0.0), Position.of(0.0, 0.0, 0.0));
            crystalShape.applyLayer(new AddLayer(Shapes.ellipticalPyramid(shardRadius, shardRadius, shardLength).applyLayer(new BendLayer(shardArc, shardRadius, shardLength)).applyLayer(new RotateLayer(Quaternion.of(Xrot3, Yrot3, Zrot3, true))))).applyLayer(new TranslateLayer(Position.of(shardMovementX, shardMovementY, shardMovementZ))).applyLayer(new RotateLayer(Quaternion.of(totalXrot, totalYrot, totalZrot, true))).applyLayer(new DilateLayer(Position.of(scale, scale, scale))).applyLayer(new DilateLayer(Position.of(1.0, yScale, 1.0))).applyLayer(new RotateLayer(Quaternion.of(uniformXrot, uniformYrot, uniformZrot, true))).applyLayer(new TranslateLayer(Position.of(pos))).validate(new SafelistValidator((IWorldGenerationBaseReader)reader, WHITELIST), validShape -> validShape.fill(new SimpleFiller((IWorldWriter)reader, CRYSTAL_TYPE)));
        }
        double added = radius * scale * (random.nextDouble() * 2.0);
        BlockPos.func_218281_b((BlockPos)pos.func_177963_a(added, added, added), (BlockPos)pos.func_177963_a(-added, -added, -added)).iterator().forEachRemaining(crystalPos -> {
            Direction preferredDirection;
            if (random.nextDouble() < 0.2) {
                Direction preferredDirection2 = Direction.func_239631_a_((Random)random);
                if (reader.func_180495_p(crystalPos.func_177972_a(preferredDirection2)).equals(((Block)BlockRegistry.VIOLITE.get()).func_176223_P()) && reader.func_175623_d(crystalPos)) {
                    reader.func_180501_a(crystalPos, (BlockState)((Block)BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:crystal_buds")).func_205596_a(random)).func_176223_P().func_206870_a((Property)CrystalBudBlock.FACING, (Comparable)preferredDirection2.func_176734_d()), 4);
                }
            } else if (random.nextDouble() < 0.4 && reader.func_180495_p(crystalPos.func_177972_a(preferredDirection = Direction.func_239631_a_((Random)random))).equals(((Block)BlockRegistry.VIOLITE.get()).func_176223_P()) && reader.func_175623_d(crystalPos)) {
                reader.func_180501_a(crystalPos, (BlockState)((Block)BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:crystal_crag_foliage")).func_205596_a(random)).func_176223_P().func_206870_a((Property)CrystalBudBlock.FACING, (Comparable)preferredDirection.func_176734_d()), 4);
            }
        });
        return true;
    }
}

